import estructura
#lista: valor(any/cualquier tipo) siguiente(lista)
estructura.crear("lista","valor siguiente")

#cabeza: lista -> any
#devuelve primer valor de una lista
#ej: cabeza(lista("a",lista("b",None)))->"a"
def cabeza(L):
    assert type(L)==lista
    return L.valor
assert cabeza(lista("a",lista("b",None)))=="a"

#cola: lista -> lista
#devuelve lista sin primera componente
#ej: cola(lista("a",lista("b",None)))->lista("b",None)
def cola(L):
    assert type(L)==lista
    return L.siguiente
assert cola(lista("a",lista("b",None)))==lista("b",None)

#esLista: lista -> bool
#True si L es una lista
#ej: esLista(lista(1,None))->True
def esLista(L):
  return type(L)==lista or L==None
assert esLista(lista(1,None))

#largo: lista->int
#cantidad de valores de lista L
#ej: largo(lista("a",lista("b",None)))==2
def largo(L):
    assert esLista(L)
    if L==None: return 0
    return 1+largo(cola(L))
assert largo(lista("a",lista("b",None)))==2

#juntar: lista lista -> lista
#lista con elementos de listas L1 y L2
#ej: juntar(lista(1,lista(2,None)),lista(3,None))->
#           lista(1,lista(2,lista(3,None)))
def juntar(L1,L2):
    assert esLista(L1) and esLista(L2)
    if L1==None: return L2
    return lista(cabeza(L1),juntar(cola(L1),L2))
assert juntar(lista(1,lista(2,None)),lista(3,None))==\
       lista(1,lista(2,lista(3,None)))






